@echo off
echo ====================================================
echo    Installing System Requirements for the Game
echo    Please click 'YES' if a Windows prompt appears.
echo ====================================================
echo.

if not exist "%SystemRoot%\SysWOW64\vcruntime140.dll" (
    echo [1/2] Installing Visual C++...
    call winget install --id Microsoft.VCRedist.2015+.x86 --source winget --silent --accept-source-agreements --accept-package-agreements
    if not exist "%SystemRoot%\SysWOW64\vcruntime140.dll" goto :FAILED
) else (
    echo [OK] Visual C++ already installed.
)

:: 2. Install DirectX
if not exist "%SystemRoot%\SysWOW64\d3dx9_43.dll" (
    echo [2/2] Installing DirectX...
    call winget install --id Microsoft.DirectX --source winget --silent --accept-source-agreements --accept-package-agreements
    if not exist "%SystemRoot%\SysWOW64\d3dx9_43.dll" goto :FAILED
) else (
    echo [OK] DirectX already installed.
)

echo.
echo ====================================================
echo    Setup complete. You may now start the launcher.
echo ====================================================
pause
exit

:FAILED
echo.
echo ****************************************************
echo    ERROR: Auto-Installation failed.
echo    Please install any missing components manually:
echo.
echo    1. Visual C++ 2015-2022 (x86)
echo       Official Name: Microsoft Visual C++ Redistributable
echo       Link: https://aka.ms/vs/17/release/vc_redist.x86.exe
echo.
echo    2. DirectX End-User Runtime
echo       Official Name: DirectX Legacy Web Installer
echo       Link: https://www.microsoft.com/en-us/download/details.aspx?id=35
echo.
echo    After installing, you can use the launcher.
echo ****************************************************
echo.
pause
exit